<?php

namespace App\Entity;

use App\Repository\SerialRepository;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass=SerialRepository::class)
 */
class Serial
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=100)
     */
    private $lastGenerated;

    /**
     * @ORM\Column(type="datetime")
     */
    private $dateUpdated;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getLastGenerated(): ?string
    {
        return $this->lastGenerated;
    }

    public function setLastGenerated(string $lastGenerated): self
    {
        $this->lastGenerated = $lastGenerated;

        return $this;
    }

    public function getDateUpdated(): ?\DateTimeInterface
    {
        return $this->dateUpdated;
    }

    public function setDateUpdated(\DateTimeInterface $dateUpdated): self
    {
        $this->dateUpdated = $dateUpdated;

        return $this;
    }
}
